<?php
class Session {
    public static function start() {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    public static function isAuthenticated() {
        self::start();
        return isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true;
    }

    public static function requireAuth() {
        if (!self::isAuthenticated()) {
            header("Location: login.php");
            exit;
        }
    }

    public static function requireRole($role) {
        self::requireAuth();
        if ($_SESSION['role'] !== $role) {
            header("Location: unauthorized.php");
            exit;
        }
    }
}
